MoreVehZones = MoreVehZones or {}

function MoreVehZones.isModdedCell(cellX, cellY)
	local dirs = getLotDirectories()
    for i=dirs:size(), 1, -1 do
		local dirName = dirs:get(i-1)
		if dirName ~= "Muldraugh, KY" then
			local lotfile = 'media/maps/'..dirName..'/'..cellX..'_'..cellY..'.lotheader'
			if fileExists(lotfile) then
				return true
			end
		end
	end
	return false
end
	
function MoreVehZones.registerVehZonesForVanilla(zoneObjs)
	for _, vz in ipairs(zoneObjs) do
		if not MoreVehZones.isModdedCell(math.floor(vz.x/256), math.floor(vz.y/256)) and vz.type == "ParkingStall" then
			local vzone = getWorld():registerVehiclesZone(vz.name, vz.type, vz.x, vz.y, vz.z, vz.width, vz.height, vz.properties)
			if vzone == nil then
				getWorld():registerZone(vz.name, vz.type, vz.x, vz.y, vz.z, vz.width, vz.height)
			end
		end
	end
end

function MoreVehZones.registerVehZonesForMods(zoneObjs)
	for _, vz in ipairs(zoneObjs) do
		if vz.type == "ParkingStall" then
			local vzone = getWorld():registerVehiclesZone(vz.name, vz.type, vz.x, vz.y, vz.z, vz.width, vz.height, vz.properties)
			if vzone == nil then
				getWorld():registerZone(vz.name, vz.type, vz.x, vz.y, vz.z, vz.width, vz.height)
			end
		end
	end
end